<?php
/*
*********************************
* Name: Amr Muhamed             *
* Email: amrmuhamed9@gmail.com  *
* Phone: +201061637022          *
* Copywrits @amrMU Githup       *
* *******************************
*/
namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Ads,App\AdsTranslations,App\AdsImages;
use App\Category;
use  App\Http\Requests\Admin\AdsRequest;
use App\Http\Controllers\ImagesController;
use Jenssegers\Agent\Agent;
use App\Helpers\DoFire;
use App\AdPurpose;
use Auth;
use Session;

class AdsController extends Controller
{
    public $view = 'panel.ads.';

    public function __construct(
			Ads $ads,
			AdsTranslations $translation,
			AdsImages $images,
			AdPurpose $purpose
		)
	{
        $this->ads = $ads;
        $this->translation = $translation;
        $this->images = $images;
        $this->purpose = $purpose;
	}


	/*
	*
	* 	Getting Edit Ads View
	*	@return view with data
	*	@method GET
	*
	**/
	public function index(Request $request)
	{
		$ads= $this->ads->with('images')->get(); 

		$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_List_Ad','text'=>'List New Add  ','browser'=>$agent];

        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);

		return view($this->view.'index',compact('ads'));
	}

	public function bannedAds(Request $request)
	{
		$ads= $this->ads->whereHas('blocked')->with('images','blocked')->get(); 
		$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_Banned_List_Ad','text'=>'Banned List Ad  ','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);
		return view($this->view.'blocked',compact('ads'));
	}

	public function banneAdd($ad_id,$status,Request $request)
	{
		$this->ads->find($ad_id)->update([
			'status'=>$status
		]);
		$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_Banned_From_List_Ad_id_'.$ad_id,'text'=>'Banned from List Ad  ','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);
		return redirect()->back();
	}
	public function create(Request $request)
	{
		$ad = [];
       
		$ad_purpose= $this->purpose->with('translation')->get();
		// dd($ad_purpose);
		$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_show_Create_Ad','text'=>'Show Create New Add  ','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);
        
		return view($this->view.'create',compact('ad','ad_purpose'));
	}

	public function store(AdsRequest $request)
	{
		if ($request->sub_categoris != null) {
			$category_id = $request->sub_categoris;
		}else{
			$category_id = $request->category_id;
		}
		$create_ad = $this->ads->create([
						'category_id'=>$category_id,
						'purpose_id'=>$request->purpose_id,
						'share_link'=>$request->share_link,
						'user_id'=>Auth::id(),
						'price'=>$request->price,
						'url'=>' ',
						'url'=>$request->url,
						// 'map'=>$request->map,
						'address'=>$request->address,
						'lat'=>$request->lat,
						'long'=>$request->long,
						'meta_tags'=>$request->meta_tags,
						'status'=>$request->status,
						'space'=>$request->space,
						'bed_ro=>$request->bed_room'=>$request->om,
						'bathroom'=>$request->bathroom,
						'parking'=>$request->parking,
					]);//end save base info
		
		if ($request->has('lang')) {
			$translation = [];
			foreach ($request->lang as $key => $lang) {
			$translation =	$this->translation->create([
									'ad_id'=>$create_ad->id,
									'lang_id'=>$lang,
									'title'=>$request->title[$key],
									'address'=>$request->address[$key],
									'content'=>$request->content[$key],
								]);
			}//end loop save translation
		}//end languages when we lave lang

		if ($request->has('images')) {
			$set_images_path_db = [];
			$upload_images = ImagesController::upload_multiple(
				$request->images,
				public_path().'/uploads/images/products',
				'/uploads/images/products'
				);

			foreach ($upload_images as $key => $image) {
				$set_images_path_db = $this->images->create([
					'image'=>$image,
					'ad_id'=>$create_ad->id
				]);
			}//end loop save images
		}//end images case when we have images

		$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_Store_New_Ad','text'=>'Store New Add  ','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),$create_ad,$request->ipinfo);
        Session::flash('success',trans('home.message_success'));

		return redirect()->back();
	}

	/*
	*
	* 	Getting Edit Ads View
	*	@return view with data
	*	@method GET
	*
	**/
	public function edit($id,Request $request)
	{
		$ad= $this->ads->find($id); 
		$ad_purpose= $this->purpose->with('translation')->get();

		$sub_categories= Category::where('parent_id','!=',null)->where('parent_id',$ad->category->parent_id)->get(); 
		$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_edit_Ad_id_'.$id,'text'=>'Show Create New Add  ','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),$ad,$request->ipinfo);
		return view($this->view.'edit',compact('ad','sub_categories','ad_purpose'));
	}

	public function update($id,AdsRequest $request)
	{

		if ($request->sub_categoris != null) {
			$category_id = $request->sub_categoris;
		}else{
			$category_id = $request->category_id;
		}
		$update  = $this->ads->find($id)->update([
						'category_id'=>$category_id,
						'purpose_id'=>$request->purpose_id,
						'share_link'=>$request->share_link,
						'user_id'=>Auth::id(),
						'price'=>$request->price,
						// 'url'=>$request->url,
						'url'=>' ',
						'map'=>$request->map,
						'meta_tags'=>$request->meta_tags,
						'status'=>$request->status,
						'type_ad'=>$request->add_type,
						'space'=>$request->space,
						'bed_ro=>$request->bed_room'=>$request->om,
						'bathroom'=>$request->bathroom,
						'parking'=>$request->parking,
					]);//end save base info

		if ($request->has('lang')) {

			$this->translation->where('ad_id',$id)->delete();
			$translation = [];
			foreach ($request->lang as $key => $lang) {
			$translation =	$this->translation->create([
									'ad_id'=>$id,
									'lang_id'=>$lang,
									'title'=>$request->title[$key],
									'address'=>$request->address[$key],
									'content'=>$request->content[$key],
								]);
			}//end loop save translation
		}//end languages when we lave lang

		if ($request->has('images')) {
			$set_images_path_db = [];
			$upload_images = ImagesController::upload_multiple(
				$request->images,
				public_path().'/uploads/images/products',
				'/uploads/images/products'
				);

			foreach ($upload_images as $key => $image) {
				$set_images_path_db = $this->images->create([
					'image'=>$image,
					'ad_id'=>$id
				]);
			}//end loop save images
		}//end images case when we have images

		// dd($request->images,$set_images_path_db);
		$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_Store_New_Ad','text'=>'Store New Add  ','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),$this->ads->find($id),$request->ipinfo);
        Session::flash('success',trans('home.message_success'));

		return redirect()->back();
	}


	public function DestroyImage($image_id,Request $request)
	{
		$image = $this->images->where('id',$image_id)->first();
		$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboar_remove_add_image_id_$'.$image_id,'text'=>'Remove Ad Image','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),$image,$request->ipinfo);
		$this->images->where('id',$image_id)->delete();
        Session::flash('success',trans('home.message_success'));
		return redirect()->back();
	}

	public function Destroy($ad_id,Request $request)
	{
		$this->ads->where('id',$ad_id)->delete();
		$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboar_remove_ad_image','text'=>'Remove Ad Image','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),$this->ads->find($ad_id),$request->ipinfo);
        Session::flash('success',trans('home.message_success'));
		return redirect()->back();
	}

	public function destroyAll(Request $request)
    {

       $agent = new Agent();
       $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
       $data = ['key'=>'dashboard_destroy_ad_ids_['.json_encode($request->ids).']','text'=>'Destroy selected ad Info','browser'=>$agent];

        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);

        if ($request->has('ids')) {
            $this->ads->wherein('id',$request->ids)->delete();
        }else{
        $this->ads->truncate();
        }
        Session::flash('success',trans('home.message_success'));
        return redirect()->back();  
    }


}
