<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Groups,App\GroupsTranslation;
use App\User,App\GroupMembers;
use App\Http\Requests\Front\GroupRequest;
use App\Http\Controllers\ImagesController;
use Jenssegers\Agent\Agent;
use App\Helpers\DoFire;
use Auth;
use Session;

class GroupsController extends Controller
{
     public $view = 'panel.groups.';

    public function __construct(
			Groups $model,
			GroupsTranslation $translation,
			GroupMembers $member
		)
	{
        $this->model = $model;
        $this->translation = $translation;
        $this->member = $member;
	}

	public function index()
	{
		$groups = $this->model->where('user_id',Auth::id())->get();
		return view($this->view.'index',compact('groups'));
	}

	public function create()
	{
		$users = User::where('type_user','user')->get();
		$group = [];
		return view($this->view.'create',compact('users','group'));
	}

	public function store(GroupRequest $request)
	{
		if ($request->hasFile('icon')) {
			$file = $request->file('icon');
    		$path = public_path().'/uploads/images/groups/'.date('o-m-d');
    		$db_path = '/uploads/images/groups/'.date('o-m-d');
    		$img = ImagesController::uploadSingle($file,$path,$db_path);
		}else{
			$img = '/img/unknown.png';
		}
		$insert =  $this->model->create([
		'user_id'=>Auth::id(),
    	'adv_id'=>NULL,
    	'type'=>$request->privacy,
    	'image'=>$img,
		]);

    	foreach ($request->lang as $key => $lang) {
			$translations = $this->translation->create([
									'lang_id'=>$lang,
									'group_id'=>$insert->id,
									'name'=>$request->name[$key],
							]);
		}

		foreach ($request->members as $key_memeber => $member) {
			$this->member->create([
				'user_id'=>$member,
    			'group_id'=>$insert->id,
			]);
		}

		Session::flash('success',trans('home.message_success'));
		return redirect()->back();
	}

	
	public function edit($id)
	{
		$group = $this->model->find($id);
		$members = $group->members;
		$users = User::where('type_user','user')->whereNotIn('id',[$members->pluck('user_id')])->get();
		// dd($group->members,$users);
		return view($this->view.'edit',compact('users','members','group'));
	}


	public function update(GroupRequest $request,$id)
	{
		$group = $this->model->find($id);
		if ($request->hasFile('icon')) {
			$file = $request->file('icon');
    		$path = public_path().'/uploads/images/groups/'.date('o-m-d');
    		$db_path = '/uploads/images/groups/'.date('o-m-d');
    		$img = ImagesController::uploadSingle($file,$path,$db_path);
		}else{
			$img = $group->image;
		}
		$insert =  $group->update([
		// 'user_id'=>Auth::id(),
    	'adv_id'=>NULL,
    	'type'=>$request->privacy,
    	'image'=>$img,
		]);

		$this->translation->where('group_id',$id)->delete();

    	foreach ($request->lang as $key => $lang) {
			$translations = $this->translation->create([
									'lang_id'=>$lang,
									'group_id'=>$id,
									'name'=>$request->name[$key],
							]);
		}
		$this->member->where('group_id',$id)->delete();
		foreach ($request->members as $key_memeber => $member) {
			$this->member->create([
				'user_id'=>$member,
    			'group_id'=>$id,
			]);
		}

		Session::flash('success',trans('home.message_success'));
		return redirect()->back();
	}

	


	public function destroy($id,Request $request)
    {

       $agent = new Agent();
       $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
       $data = ['key'=>'dashboard_destroy_group_id'.$id,'text'=>'Destroy group Info','browser'=>$agent];
       $info  = $this->model->find($id);

           DoFire::MK_REPORT($data,Auth::id(),$info,$request->ipinfo);
           $this->model->destroy($id);
        Session::flash('success',trans('home.message_success'));
        return redirect()->back();  
    }


    public function destroySelected(Request $request)
    {

       $agent = new Agent();
       $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
       $data = ['key'=>'dashboard_destroy_group_ids_['.json_encode($request->ids).']','text'=>'Destroy selected Group Info','browser'=>$agent];

        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);

        if ($request->has('ids')) {
            $this->model->wherein('id',$request->ids)->delete();
        }else{
        $this->model->truncate();
        }
        Session::flash('success',trans('home.message_success'));
        return redirect()->back();  
    }


}
