<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Notifications,App\NotificationReciver;
use Jenssegers\Agent\Agent;
use App\Helpers\DoFire;
use App\User;
use Session;
use Auth;

class NotificationsController extends Controller
{
    public $view = 'panel.notifications.';

	public function __construct(
	Notifications $model,
	NotificationReciver $reciver
	){
		$this->model = $model;
		$this->reciver = $reciver;

	}

	public function index()
	{
		$notifications =  $this->model->with('notify_ricervers')->get();
		return view($this->view.'index',compact('notifications'));
	}
	public function create()
	{
		$users = User::where('type_user','user')->get();
		return view($this->view.'create',compact('users'));
	}

	public function store(Request $request)
	{
		$request->validate([
		  	'title'=>'required',
            'msg'=>'required|min:5',
            'users.*'=>'required'
		]);


		$notification = $this->model->create([
			'sender_id'=>Auth::id(),
			'title'=>$request->title,
			'msg'=>$request->msg
		]);
		
		foreach ($request->users as $key => $reciver) {
			$user_notification  = $this->reciver->create([
				'reciver_id'=>$reciver,
				'notification_id'=>$notification->id
			]);


			// $token_check = $this->HasToken($reciver,$notification->title,$notification->message);
		}

		$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_destroy_notification_id_['.$notification->id.']','text'=>'Destroy selected notification Info','browser'=>$agent];

        DoFire::MK_REPORT($data,Auth::id(),$notification,$request->ipinfo);

		Session::flash('success',trans('home.message_success'));
		return redirect()->back();
	}

	static public function HasToken($reciver_id,$title,$message)
	{
		
		$find_token = DeviceToken::where('user_id',$reciver_id)->get();

		if ($find_token->count() > 0) {
			//send notification
				$optionBuilder = new OptionsBuilder();
				$optionBuilder->setTimeToLive(60*20);

				$notificationBuilder = new PayloadNotificationBuilder($title);
				$notificationBuilder->setBody($message)->setSound('default');

				$dataBuilder = new PayloadDataBuilder();
				$dataBuilder->addData(['a_data' => 'my_notification']);

				$option = $optionBuilder->build();
				$notification = $notificationBuilder->build();
				$data = $dataBuilder->build();
			
			$tokens = $find_token->pluck('token')->toArray();

			$downstreamResponse = FCM::sendTo($tokens, $option, $notification, $data);

			$downstreamResponse->numberSuccess();
			$downstreamResponse->numberFailure();
			$downstreamResponse->numberModification();

			$result = true;
		}else{
			Session::flash('error',trans('home.token_not_valid'));
			$result = false;

		}
		return $result;

	}

	public function destroy($id,Request $request)
	{
		$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_destroy_notification_id_['.$id.']','text'=>'Destroy selected notification Info','browser'=>$agent];

        DoFire::MK_REPORT($data,Auth::id(),$this->model->find($id),$request->ipinfo);
		$this->model->destroy($id);
		Session::flash('success',trans('home.deleted_successfully'));
		return redirect()->back();
	}


	public function destroySelected(Request $request)
    {

       $agent = new Agent();
       $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
       $data = ['key'=>'dashboard_destroy_notification_ids_['.json_encode($request->ids).']','text'=>'Destroy selected notification Info','browser'=>$agent];

        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);

        if ($request->has('ids')) {
            $this->model->wherein('id',$request->ids)->delete();
        }else{
        $this->pages->truncate();
        }
        Session::flash('success',trans('home.message_success'));
        return redirect()->back();  
    }

}
