<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Slider,App\SliderTranslation;
use App\Http\Requests\Admin\SliderRequest;
use Jenssegers\Agent\Agent;
use App\Helpers\DoFire;
use Auth;
use Session;

class SliderController extends Controller
{
  	public $view = 'panel.sliders.';
    
    public function __construct(Slider $sliders,SliderTranslation $translation)
	{
        $this->sliders = $sliders;
        $this->translation = $translation;
	}

	public function index(Request $request)
    {
    	$sliders = $this->sliders->all();
    	$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_list_sliders','text'=>'List All sliders','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);
    	return view($this->view.'index',compact('sliders'));
    }

   	public function create(Request $request)
    {
    	$slider=  [];
    	$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_create_new_slider_view','text'=>'Create_New_slider View','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);
    	return view($this->view.'create',compact('slider'));
    }


    public function store(SliderRequest $request)
    {
	    if ($request->hasFile('img')) {
            $time = time();
            $ext  =$request->file('img')->getClientOriginalExtension();
            $fullname = $time . '.' . $ext;
            $request->file('img')->move(public_path() .'/uploads/images/sliders', $fullname);
            $path ='/uploads/images/sliders';
            $img = $path.'/'.$fullname;
        }else{
        	$img = '';
        }

    	$create = $this->sliders->create([
    		'visit_url'=>$request->visit_url,
    		'img'=>$img,
    	]);

    	foreach ($request->lang as $key => $lang) {
	    	$translation = $this->translation->create([
	    		'title'=>$request->title[$key],
	    		'content'=>$request->content[$key],
	    		'lang_id'=>$lang,
	    		'slider_id'=>$create->id
	    	]);
    	}

    	$agent = new Agent();
    	$agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_create_new_slider','text'=>'Create New slider','browser'=>$agent];
        session::flash('success',trans('home.message_success'));
    	return redirect()->back();
    }

    public function edit($id,Request $request)
    {
    	$slider  = $this->sliders->find($id);
    	$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_edit_sider_view_id:'.$id,'text'=>'dashboard edit sider view ','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);
    	return view($this->view.'edit',compact('slider'));
    }


    public function update(SliderRequest $request,$id)
    {
    	if ($request->hasFile('img')) {
            $time = time();
            $ext  =$request->file('img')->getClientOriginalExtension();
            $fullname = $time . '.' . $ext;
            $request->file('img')->move(public_path() .'/uploads/images/sliders', $fullname);
            $path ='/uploads/images/sliders';
            $img = $path.'/'.$fullname;
        }else{
        	$img = $this->sliders->find($id)->img;
        }

    	$create = $this->sliders->find($id)->update([
    		'visit_url'=>$request->visit_url,
    		'img'=>$img,
    	]);
    	
    	$this->translation->where('slider_id',$id)->delete();
    	foreach ($request->lang as $key => $lang) {
	    	$translation = $this->translation->create([
				'title'=>$request->title[$key],
	    		'content'=>$request->content[$key],
	    		'lang_id'=>$lang,
	    		'slider_id'=>$id
	    	]);
    	}

    	$agent = new Agent();
    	$agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_update_slider_id:'.$id,'text'=>'update Slider','browser'=>$agent];
        session::flash('success',trans('home.message_success'));
    	return redirect()->back();
    }


    public function destroy($id,Request $request)
    {
    	$this->sliders->where('id',$id)->delete();

    	$agent = new Agent();
    	$agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_update_country_id:'.$id,'text'=>'update Country','browser'=>$agent];
        session::flash('success',trans('home.message_success'));
    	return redirect()->back();
    }


    public function destroySelected(Request $request)
    {
    	$this->sliders->whereIn('id',$request->ids)->delete();
    	$agent = new Agent();
    	$agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_delete_countres:','text'=>'Delte Countries','browser'=>$agent];
        session::flash('success',trans('home.message_success'));
    	return redirect()->back();
    }
}
