<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\ContactUsRequest;
use App\Contactus;
use Validator;
use Response;


class ContactUsController extends Controller
{
    public function validation($request)
    {
         $validator = Validator::make($request, [
              'name'=>'required|min:5|max:180',
	          'subject'=>'required',
	          'email'=>'required|email',
	          'message'=>'required|min:5|max:180',
        ]);

        if ($validator->fails()) {
            $msg = $validator->errors()->first();
            $response = [
                    'success'=>FALSE,
                    'message'=>$msg,
                    'data'=>[]
                ];   
               return $response;  
        }
    }

    public function posttSendAsk(Request $request)
    {
    	$validation = $this->validation($request->all());
      
        if($validation != null){
            return Response::json($validation,400) ; 
        }
    	Contactus::create([
    			'name'=>$request->name,
				'subject'=>$request->subject,
				'email'=>$request->email,
				'message'=>$request->message,
    	]);

    	$msg = "تم ارسال الطلب بنجاح";
    	$response = [
                    'success'=>TRUE,
                    'message'=>$msg,
                    'data'=>[]
                ];   
        return Response::json($response,200) ; 

    }
}
