<?php

namespace App\Http\Controllers\Front\User;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\User,App\Followers,App\County;
use App\City;
use Session;
use Auth;


class ProfilController extends Controller
{
     public $view = 'front.user.';

   	public function profile($id,$name)
   	{
   		$user = User::find($id);
         if (Auth::check() && $user != null) {
   		$followers = Followers::where('user_id',$user->id)->get();
   		$followers=$followers->pluck('fan_id');
         }else{
            $followers = [];
         }
         $countries = County::with('translations')->get();
         $cities = City::with('translations')->get();
   		return view($this->view.'profile',compact('user','followers','countries','cities'));
   	}

      public function update(Request $request)
      {
         $update =   User::find(Auth::id())->update([
            'fname'=>$request->name,
            'email'=>$request->email,
            'phone'=>$request->phone,
            'address'=>$request->address,
            'commercial_register'=>$request->commercial_register,
            'governmental_id'=>$request->governmental_id,
            'job_title'=>$request->job_title,
            'country_id'=>$request->country_id,
            'city_id'=>$request->city_id,
            'gander'=>$request->gander,
         ]);


         if ($request->has('password')) {
            User::find(Auth::id())->update([
               'password'=>bcrypt($request->password),
            ]);
         }
         if($request->hasFile('image')){
            $file =$request->file('image');
            $time = time();
            $ext = $file->getClientOriginalExtension();
            $fullname = $time . '.' . $ext;
            $move = $file->move(public_path() .'/uploads/images/users', $fullname);
            $path ='/uploads/images/users';
            $image = $path.'/'.$fullname;
            User::where('id',Auth::id())->update(['image'=>$image]);
        }
      Session::flash('success',trans('home.message_success'));
      return redirect()->back();
      }
   	public function followers($influencer_id)
   	{
   		$list = Followers::where('user_id',$influencer_id)->get();
   		return view($this->view.'followers.index',compact('list'));
   	}

   	public function following($influencer_id)
   	{
   		$list = Followers::where('fan_id',$influencer_id)->get();

   		return view($this->view.'following.index',compact('list'));
   	}

}
