<?php

namespace App\Notifications\Admin;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Config;

class ContactUsNotify extends Notification
{
    use Queueable;

    // public $contact; 
    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($contact)
    {
        $this->contact = $contact ;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        $mail  = (new MailMessage)
                    ->greeting('Hello!')
                    ->line($this->contact['message'])
                    ->action(Config::get('app.name'), url('/'))
                    ->subject($this->contact['subject']);

        if ($this->contact['moreUsers'][0] != null) {
           $mail->cc($this->contact['moreUsers']);
        }
         if ($this->contact['evenMoreUsers'][0] != null) {
           $mail->cc($this->contact['evenMoreUsers']);
        }
      
        return $mail;
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($request)
    {
        return [
            //
        ];
    }
}
