<!DOCTYPE html>
<html lang="zxx">

<head>

    <!-- Metas -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
    

    @include('panel.layouts.meta_tags_social')

    <!-- Title  -->
    <title>{{ @$setting->translation->title }}-استعادة كلمة المرور</title>


    <!-- Favicon -->
    <link rel="shortcut icon" href="images/favicon.png" />

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Cairo:200,300,400,600,700,900&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Tajawal:200,300,400,500,700,800,900&display=swap"
        rel="stylesheet">

    <!-- Plugins -->
    <link rel="stylesheet" href="{{ asset('cpanel') }}/css/plugins.css" />

    <!-- bootstrap-ltr.min -->
    <link rel="stylesheet" href="{{ asset('cpanel') }}/css/bootstrap-ltr.min.css" />

    <!-- bootstrap-rtl.min -->
    <link rel="stylesheet" href="{{ asset('cpanel') }}/css/bootstrap-rtl.min.css" />

    <!-- Core Style Css -->
    <link rel="stylesheet" href="{{ asset('cpanel') }}/css/style.css" />

</head>

<body>

    <!-- =====================================
          ==== Start Loading -->

    <div class="loading valign">
        <div class="full-width">
            <div class="lds-ripple">
                <div></div>
                <div></div>
            </div>
            <div class="load-logo">
                <img src="{{ asset('/').@$setting->logo }}" alt="">
            </div>
        </div>
    </div>

    <!-- End Loading ====
        ======================================= -->



    <!-- =====================================
        ==== Start login -->
        
            <section class="login">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-lg-7 col-md-9">
                            <div class="box">
                                <div class="title">
                                    <h5 class="content-group">إعادة تعيين استعادة كلمة المرور <small class="display-block">الآن يمكنك إعادة تعيين كلمة المرور الخاصة بك</small></h5>
                                </div>
                               
                               <form method="POST" action="{{ route('password.update') }}">
                                @csrf
                                 @if (session('status'))
                                 <div class="alert alert-success" role="alert">
                                    {{ session('status') }}
                                </div>
                                @endif
                                @csrf
                                <div class="form-group">
                                     <input  id="password" type="password" class="form-control{{ $errors->has('password') ? ' is-invalid' : '' }}" name="password" value="{{ old('password') }}" >
                                    <i class="fas fa-unlock-alt"></i>
                                     @if ($errors->has('password'))
                                    <span class="invalid-feedback " role="alert">
                                        <strong class="text-danger">{{ $errors->first('password') }}</strong>
                                    </span>
                                @endif
                                </div>
                                <div class="form-group">
                                   <input  id="password" type="password" class="form-control{{ $errors->has('password_confirmation') ? ' is-invalid' : '' }}" name="password_confirmation" value="{{ old('password_confirmation') }}" >
                                   @if ($errors->has('password'))
                                   <span class="invalid-feedback " role="alert">
                                    <strong class="text-danger">{{ $errors->first('password_confirmation') }}</strong>
                                </span>
                                @endif
                                    <i class="far fa-eye-slash"></i>
                                </div>

                                    <button type="submit">    {{ __('إعادة تعيين كلمة المرور') }} <i class="icon-arrow-left13 position-right"></i></button>
                                <div class="bottom">
                                    <p><a href="{{ URL::to('/admin') }}">@lang('home.login')</a></p>
                                   
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
    <!-- End login ====
        ======================================= -->





    <!-- jQuery -->
    <script src="{{ asset('cpanel') }}/js/jquery-3.0.0.min.js"></script>
    <script src="{{ asset('cpanel') }}/js/jquery-migrate-3.0.0.min.js"></script>

    <!-- popper.min -->
    <script src="{{ asset('cpanel') }}/js/popper.min.js"></script>

    <!-- bootstrap -->
    <script src="{{ asset('cpanel') }}/js/bootstrap.min.js"></script>

    <!-- aos js -->
    <script src="{{ asset('cpanel') }}/js/wow.min.js"></script>

    <!-- jquery-ui  -->
    <script src="{{ asset('cpanel') }}/js/jquery-ui.js"></script>

    <!-- jquery.magnific-popup.min js -->
    <script src="{{ asset('cpanel') }}/js/jquery.magnific-popup.min.js"></script>

    <!-- jquery.waypoints.min -->
    <script src="{{ asset('cpanel') }}/js/jquery.waypoints.min.js"></script>

    <!-- jquery.counterup.min -->
    <script src="{{ asset('cpanel') }}/js/jquery.counterup.js"></script>

    <!-- validator js -->
    <script src="{{ asset('cpanel') }}/js/validator.js"></script>

    <!-- custom scripts -->
    <script src="{{ asset('cpanel') }}/js/scripts.js"></script>

    <script>
        new WOW().init();
    </script>

    <script>

        $('.count').counterUp({
            delay: 10,
            time: 2000
        });

        $('.count-long').counterUp({
            delay: 10,
            time: 4000
        });

    </script>

    <script>
        $(function () {

            // Remove svg.radial-progress .complete inline styling
            $('svg.radial-progress').each(function (index, value) {
                $(this).find($('circle.complete')).removeAttr('style');
            });

            // Activate progress animation on scroll
            $(window).scroll(function () {
                $('svg.radial-progress').each(function (index, value) {
                    // If svg.radial-progress is approximately 25% vertically into the window when scrolling from the top or the bottom
                    if (
                        $(window).scrollTop() > $(this).offset().top - ($(window).height() * 0.75) &&
                        $(window).scrollTop() < $(this).offset().top + $(this).height() - ($(window).height() * 0.25)
                    ) {
                        // Get percentage of progress
                        percent = $(value).data('percentage');
                        // Get radius of the svg's circle.complete
                        radius = $(this).find($('circle.complete')).attr('r');
                        // Get circumference (2πr)
                        circumference = 2 * Math.PI * radius;
                        // Get stroke-dashoffset value based on the percentage of the circumference
                        strokeDashOffset = circumference - ((percent * circumference) / 100);
                        // Transition progress for 1.25 seconds
                        $(this).find($('circle.complete')).animate({ 'stroke-dashoffset': strokeDashOffset }, 1250);
                    }
                });
            }).trigger('scroll');

        });
    </script>
    <script>

        var _gaq = _gaq || [];
        _gaq.push(['_setAccount', 'UA-36251023-1']);
        _gaq.push(['_setDomainName', 'jqueryscript.net']);
        _gaq.push(['_trackPageview']);

        (function () {
            var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
            ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
            var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
        })();

    </script>



</body>

</html>