@extends('front.layouts.main')
@section('meta_tags')
    <title> {{ @$ad->translations->where('lang_id',$active_lang->id)->first()->title }} | {{@$setting->translation->title}}</title>
    <meta name='description' itemprop='description' content='{!! @$info->translation->content!!}' />
    <meta name='keywords' content='{!!@$setting->meta_tags!!},{!!@$info->translation->title !!},{!!@$info->mission !!},{!!@$info->goals!!}' />
    <meta property="og:description"content="{{ @$info->translation->content }}" />
    <meta property="og:title"content=" {{ @$ad->translations->where('lang_id',$active_lang->id)->first()->title }} | {{@$setting->translation->title}} " />
    <meta property="og:url"content="{{URL::to('/about_us')}}" />
    <meta property="og:site_name"content="{{@$setting->translation->title}}" />
    <meta property="og:image" content="{{URL::to('/').@$setting->logo}}">

    <meta name="twitter:card"content="summary" />
    <meta name="twitter:title"content=" {{ @$ad->translations->where('lang_id',$active_lang->id)->first()->title }}| {{@$setting->translation->title}}" />
    <meta name="twitter:site"content="@wait" />
@stop
@section('content')
     <!--Contents-->
    <main class="inner-pages">
        <div class="inner-header">
            <div class="page-title">
                <div class="container">
                    <h5 class=""><a href="{{url(LaravelLocalization::getCurrentLocale())}}">@lang('home.home')</a> / {{ @$ad->translations->where('lang_id',$active_lang->id)->first()->title }}</h5>
                </div>
            </div>
        </div>
        <section class="adv-det section-padding">
        <!-- ======================== start about =========================== -->
        
            <div class="container">
                <div class="section-head text-center">
                    <small>{{ @$category->translations->where('lang_id',$active_lang->id)->first()->name }}</small>
                    <br>
                    <h2>@lang('home.ad_details')</h2>
                </div>
                <div class="content">
                    <div class="row">
                        <div class="col-lg-10 offset-lg-1">
                            <div class="user-details">
                                <ul>
                                    <li>@lang('home.auther'): <span>{{ @$ad->user->fname.' '.@$ad->user->lname.' '.@$ad->user->family_name }}</span></li>
                                    <Li>@lang('home.date_time') : <span>{{@Carbon\Carbon::parse($ad->created_at)->diffForHumans()}} -  {{ @$ad->created_at }}</span></Li>
                                    <li>@lang('home.ad_purpose'): <span>{{ @$ad->ad_purpose->translations->where('lang_id',$active_lang->id)->first()->name }}</span></li>
                                   {{--  <li>المشاهدات والردود: <span> <a href="#">5 مشاهدات</a> <a href="#">3
                                                ردود</a></span></li>
                                    <li>مشاركه :
                                        <span class="share">
                                            <a href="#"><i class="fab fa-facebook-f"></i></a>
                                            <a href="#"><i class="fab fa-twitter"></i></a>
                                            <a href="#"><i class="fab fa-instagram"></i></a>
                                        </span>
                                    </li>
                                    <li><a class="report" href="#">أبلاغ عن الاعلان</a>< --}}/li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    {{-- ================================================= --}}
                    <div class="ad-details">
                        <div class="row">
                            <div class="col-lg-6 valign">
                                <div class="info">
                                    <h3>{{ @$ad->translations->where('lang_id',$active_lang->id)->first()->title }}</h3>
                                    <p>{{ @$ad->translations->where('lang_id',$active_lang->id)->first()->content }}</p>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <div class="owl-carousel owl-theme">
                                    @foreach($ad->images as $image)
                                    <div class="img">
                                        <img src="{{ asset(@$image->image) }}" alt="">
                                    </div>
                                    @endforeach
                                  {{--   <div class="img">
                                        <img src="images/road.png" alt="">
                                    </div> --}}
                                </div>
                            </div>
                        </div>
                    </div>
                    {{-- ================================================= --}}


                </div>
            </div>
        </section>
        <!-- ======================== start testmonials =========================== -->
        <div class="testmonials section-padding">
            <div class="container">
                <div class="section-head text-center">
                    <small> يمكنك أضافه تعليق </small>
                    <br>
                    <h2>تعليقات المستخدمين</h2>
                </div>

                <div class="row roww">
                    <div class="col-lg-5">
                        <form method="post" action="{{ url('ads/review/').'/'.@$ad->id }}">
                          @if ($errors->any())
                          @foreach ($errors->all() as $error)
                          <div class="alert alert-danger alert-dismissible" >
                            <a href="#" class="close" data-dismiss="alert" aria-label="close" style="right: 5px;">&times;</a>{{@$error }}
                        </div>
                        @endforeach
                        @endif
                        @if(Session::has('success'))
                        <div class="alert alert-success alert-dismissible">
                            <a href="#" class="close" data-dismiss="alert" aria-label="close" style="right: 5px;">&times;</a>{{ Session::get('success') }}
                        </div>
                        @endif
                        @csrf
                            <div class="form-row">
                              
                                <div class="col-12">
                                    <textarea class="form-control" name="comment" rows="4" placeholder="@lang('home.content')"></textarea>
                                </div>
                            </div>
                            <button class="butn"><span>@lang('home.send')</span></button>
                        </form>
                    </div>
                    <div class="col-lg-7">
                        <!-- Swiper -->
                        <div class="swiper-container text-center">
                            <div class="swiper-wrapper">
                                @foreach($ad->reviews as $review)
                                <div class="swiper-slide">
                                    <div class="img">
                                        <img src="{{ asset($review->user->image) }}" alt="">
                                    </div>
                                    <p>{{ @$review->comment }}</p>
                                    <h5>{{ @$review->user->fname }}</h5>
                                </div>
                                @endforeach
                            {{--     <div class="swiper-slide">
                                    <div class="img">
                                        <img src="images/trainer.jpg" alt="">
                                    </div>
                                    <p>عند موافقه العميل المبدئيه على التصميم يتم ازالة هذا النص من التصميم ويتم وضع
                                        النصوص النهائية المطلوبة للتصميم ويقول البعض ان وضع النصوص التجريبية بالتصميم قد
                                        تشغل المشاهد عن وضع الكثير من الملاحظات .</p>
                                    <h5>محمد احمد</h5>
                                </div> --}}
                            </div>
                            <!-- Add Pagination -->
                            <div class="swiper-pagination"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
    <!--End-Contents-->
@stop