@extends('front.layouts.main')
@section('meta_tags')
    <title>{{ @$category->translations->where('lang_id',$active_lang->id)->first()->name }} | {{@$setting->translation->title}}</title>
    <meta name='description' itemprop='description' content='{!! @$info->translation->content!!}' />
    <meta name='keywords' content='{!!@$setting->meta_tags!!},{!!@$info->translation->title !!},{!!@$info->mission !!},{!!@$info->goals!!}' />
    <meta property="og:description"content="{{ @$info->translation->content }}" />
    <meta property="og:title"content="{{ @$category->translations->where('lang_id',$active_lang->id)->first()->name }} | {{@$setting->translation->title}} " />
    <meta property="og:url"content="{{URL::to('/about_us')}}" />
    <meta property="og:site_name"content="{{@$setting->translation->title}}" />
    <meta property="og:image" content="{{URL::to('/').@$setting->logo}}">

    <meta name="twitter:card"content="summary" />
    <meta name="twitter:title"content="{{ @$category->translations->where('lang_id',$active_lang->id)->first()->name }}| {{@$setting->translation->title}}" />
    <meta name="twitter:site"content="@wait" />
@stop
@section('content')
  <!--Contents-->
    <main class="inner-pages">
        <div class="inner-header">
            <div class="page-title">
                <div class="container">
                    <h5 class=""><a href="#">@lang('home.home')</a> / @if($category->parent_id != null) {{ @$category->category->translations->where('lang_id',$active_lang->id)->first()->name }}  / @endif{{ @$category->translations->where('lang_id',$active_lang->id)->first()->name }}
                    </h5>
                </div>
            </div>
        </div>
        <!-- ======================== start about =========================== -->
        <section class="lead-section section-padding">
            <div class="container">
                <div class="section-head text-center">
                	@if($category->parent_id != null)
                    <small>{{ @$category->category->translations->where('lang_id',$active_lang->id)->first()->name }}</small>
                    <br>
                   @endif
	               @if($classifications->count() > 0)
    	                <h2>@lang('home.classifications')</h2>
                   @endif
                
                </div>
                @if($classifications->count() > 0)
                <div class="lead">
                    <div class="container">
                        <div class="row">
                           @foreach($classifications as $cat )
                            <div class="col-lg-3">
                                <a href="{{url(LaravelLocalization::getCurrentLocale()).'/category/'.@$cat->id.'/'.@$cat->translations->where('lang_id',$active_lang->id)->first()->name}}">
                                    <div class="items">
                                        <div class="icon">
                                            <img src="{{ @asset($cat->icon) }}" alt="">
                                        </div>
                                        <div class="content">
                                            <h5>{{ @$cat->translations->where('lang_id',$active_lang->id)->first()->name }}</h5>
                                           
                                        </div>
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320">
                                            <path fill="#0099ff" fill-opacity="1"
                                                d="M0,32L34.3,80C68.6,128,137,224,206,234.7C274.3,245,343,171,411,149.3C480,128,549,160,617,144C685.7,128,754,64,823,80C891.4,96,960,192,1029,202.7C1097.1,213,1166,139,1234,112C1302.9,85,1371,107,1406,117.3L1440,128L1440,320L1405.7,320C1371.4,320,1303,320,1234,320C1165.7,320,1097,320,1029,320C960,320,891,320,823,320C754.3,320,686,320,617,320C548.6,320,480,320,411,320C342.9,320,274,320,206,320C137.1,320,69,320,34,320L0,320Z">
                                            </path>
                                        </svg>
                                    </div>
                                </a>
                            </div>
                            @endforeach

                          {{--   <div class="col-lg-3">
                                <a href="#">
                                    <div class="items">
                                        <div class="icon">
                                            <img src="images/loc.svg" alt="">
                                        </div>
                                        <div class="content">
                                            <h5>الأعلانات</h5>
                                            <p>لوريم ايبسوم هو نموذج افتراضي يوضع في التصاميم لتعرض على العميل ليتصور
                                                طريقه
                                                وضع
                                                النصوص بالتصاميم</p>
                                        </div>
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320">
                                            <path fill="#00D15B" fill-opacity="1"
                                                d="M0,32L34.3,80C68.6,128,137,224,206,234.7C274.3,245,343,171,411,149.3C480,128,549,160,617,144C685.7,128,754,64,823,80C891.4,96,960,192,1029,202.7C1097.1,213,1166,139,1234,112C1302.9,85,1371,107,1406,117.3L1440,128L1440,320L1405.7,320C1371.4,320,1303,320,1234,320C1165.7,320,1097,320,1029,320C960,320,891,320,823,320C754.3,320,686,320,617,320C548.6,320,480,320,411,320C342.9,320,274,320,206,320C137.1,320,69,320,34,320L0,320Z">
                                            </path>
                                        </svg>
                                    </div>
                                </a>
                            </div>
                            <div class="col-lg-3">
                                <a href="#">
                                    <div class="items">
                                        <div class="icon">
                                            <img src="images/loc.svg" alt="">
                                        </div>
                                        <div class="content">
                                            <h5>الأعلانات</h5>
                                            <p>لوريم ايبسوم هو نموذج افتراضي يوضع في التصاميم لتعرض على العميل ليتصور
                                                طريقه
                                                وضع
                                                النصوص بالتصاميم</p>
                                        </div>
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320">
                                            <path fill="#7529C5" fill-opacity="1"
                                                d="M0,32L34.3,80C68.6,128,137,224,206,234.7C274.3,245,343,171,411,149.3C480,128,549,160,617,144C685.7,128,754,64,823,80C891.4,96,960,192,1029,202.7C1097.1,213,1166,139,1234,112C1302.9,85,1371,107,1406,117.3L1440,128L1440,320L1405.7,320C1371.4,320,1303,320,1234,320C1165.7,320,1097,320,1029,320C960,320,891,320,823,320C754.3,320,686,320,617,320C548.6,320,480,320,411,320C342.9,320,274,320,206,320C137.1,320,69,320,34,320L0,320Z">
                                            </path>
                                        </svg>
                                    </div>
                                </a>
                            </div>
                            <div class="col-lg-3">
                                <a href="#">
                                    <div class="items">
                                        <div class="icon">
                                            <img src="images/loc.svg" alt="">
                                        </div>
                                        <div class="content">
                                            <h5>الأعلانات</h5>
                                            <p>لوريم ايبسوم هو نموذج افتراضي يوضع في التصاميم لتعرض على العميل ليتصور
                                                طريقه
                                                وضع
                                                النصوص بالتصاميم</p>
                                        </div>
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320">
                                            <path fill="#2747BA" fill-opacity="1"
                                                d="M0,32L34.3,80C68.6,128,137,224,206,234.7C274.3,245,343,171,411,149.3C480,128,549,160,617,144C685.7,128,754,64,823,80C891.4,96,960,192,1029,202.7C1097.1,213,1166,139,1234,112C1302.9,85,1371,107,1406,117.3L1440,128L1440,320L1405.7,320C1371.4,320,1303,320,1234,320C1165.7,320,1097,320,1029,320C960,320,891,320,823,320C754.3,320,686,320,617,320C548.6,320,480,320,411,320C342.9,320,274,320,206,320C137.1,320,69,320,34,320L0,320Z">
                                            </path>
                                        </svg>
                                    </div>
                                </a>
                            </div> --}}
                        </div>
                    </div>
                </div>
                @endif

                <div class="lead-table">
                    <div class="container">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col">@lang('home.title')</th>
                                    <th scope="col">@lang('home.ad_purpose')</th>
                                    <th scope="col">@lang('home.date_time')</th>
                                    <th scope="col">@lang('home.statistics')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if($ads->count() > 0)
                                @foreach($ads as $ad)
                                <tr>
                                    <td>{{ @$ad->id }}</td>
                                    <td><a href="{{url(LaravelLocalization::getCurrentLocale().'/ad/'.@$ad->id.'/'. str_replace(' ','_',$ad->translations->where('lang_id',$active_lang->id)->first()->title) )}}">{{ $ad->translations->where('lang_id',$active_lang->id)->first()->title }}</a></td>
                                    <td>{{ @$ad->ad_purpose->translations->where('lang_id',$active_lang->id)->first()->name }}</td>
                                    <td> {{@Carbon\Carbon::parse($ad->created_at)->diffForHumans()}} -  {{ @$ad->created_at }}</td>
                                    <td>{{ @$ad->visit }} @lang('home.visits') <br>3 ردود</td>
                                </tr>
                                @endforeach
                                @else
                                <tr >
                                    <td colspan="5">@lang('home.no_ads_here')</td>
                                 </tr>
                                 @endif

                           
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </section>
    </main>
    <!--End-Contents-->
@stop