@extends('front.layouts.main')
@section('meta_tags')
    <title>{{ @$page->translations->where('lang_id',$active_lang->id)->first()->title }} | {{@$setting->translation->title}}</title>
    <meta name='description' itemprop='description' content='{!! @$info->translation->content!!}' />
    <meta name='keywords' content='{!!@$setting->meta_tags!!},{!!@$info->translation->title !!},{!!@$info->mission !!},{!!@$info->goals!!}' />
    <meta property="og:description"content="{{ @$info->translation->content }}" />
    <meta property="og:title"content="{{ @$page->translations->where('lang_id',$active_lang->id)->first()->title }} | {{@$setting->translation->title}} " />
    <meta property="og:url"content="{{URL::to('/about_us')}}" />
    <meta property="og:site_name"content="{{@$setting->translation->title}}" />
    <meta property="og:image" content="{{URL::to('/').@$setting->logo}}">

    <meta name="twitter:card"content="summary" />
    <meta name="twitter:title"content="{{ @$page->translations->where('lang_id',$active_lang->id)->first()->title }}| {{@$setting->translation->title}}" />
    <meta name="twitter:site"content="@wait" />
@stop
@section('content')
    <!--Contents-->
    <main class="inner-pages">
        <div class="inner-header">
            <div class="page-title">
                <div class="container">
                    <h5 class=""><a href="{{ url(LaravelLocalization::getCurrentLocale()) }}">@lang('home.home')</a> / {{ @$page->translations->where('lang_id',$active_lang->id)->first()->title }}</h5>
                </div>
            </div>
        </div>
        <!-- ======================== start about =========================== -->
        <section class="about terms section-padding">
            <div class="container">
                <div class="section-head text-center">
                    <br>
                    <h2>{{ @$page->translations->where('lang_id',$active_lang->id)->first()->title }}</h2>
                </div>

                <div class="row">
                    <div class="col-lg-8 valign">
                        <div class="items wow fadeInRight">
                            <div class="info">
                                <h2>{{ $page->translations->where('lang_id',$active_lang->id)->first()->title }}</h2>
                                <ul>
                                    <li>
                                        <span></span>
                                        <p>{{ $page->translations->where('lang_id',$active_lang->id)->first()->content }}</p>
                                    </li>
                                    
                                </ul>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="items wow zoomIn">
                            <div class="img">
                                <img src="{{ asset($page->icon) }}" alt="">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

    </main>
@stop