@extends('front.layouts.main')
@section('meta_tags')
    <title>@lang('home.following') | {{@$setting->translation->title}}</title>
    <meta name='description' itemprop='description' content='{!! @$info->translation->content!!}' />
    <meta name='keywords' content='{!!@$setting->meta_tags!!},{!!@$info->translation->title !!},{!!@$info->mission !!},{!!@$info->goals!!}' />
    <meta property="og:description"content="{{ @$info->translation->content }}" />
    <meta property="og:title"content="@lang('home.following') | {{@$setting->translation->title}} " />
    <meta property="og:url"content="{{URL::to('/about_us')}}" />
    <meta property="og:site_name"content="{{@$setting->translation->title}}" />
    <meta property="og:image" content="{{URL::to('/').@$setting->logo}}">

    <meta name="twitter:card"content="summary" />
    <meta name="twitter:title"content="@lang('home.following')| {{@$setting->translation->title}}" />
    <meta name="twitter:site"content="@wait" />
@stop
@section('content')
    <!--Contents-->
    <main class="inner-pages">
        <div class="inner-header">
            <div class="page-title">
                <div class="container">
                    <h5 class=""><a href="{{ url(LaravelLocalization::getCurrentLocale()) }}">@lang('home.home')</a> / @lang('home.following')</h5>
                </div>
            </div>
        </div>
        <!-- ======================== start about =========================== -->
        <section class="lead-section section-padding">
            <div class="container">
                <div class="section-head text-center">
                    <h2>@lang('home.following')</h2>
                </div>
                <div class="lead follow">
                    <div class="container">
                        <div class="row">
                            @if($list->count() > 0)
                            @foreach($list as $item)
                            <div class="col-lg-4">
                                <div class="items">
                                    <a href="#">
                                        <div class="icon">
                                            <img src="{{ @asset($item->user->image) }}" alt="">
                                        </div>
                                        <div class="content">
                                            <h5> {{ @$item->user->fname.' '.$item->user->lname.' '.$item->user->family_name }}</h5>
                                            <ul>
                                                <li>
                                                    <p>@lang('home.phone') : <span> {{ @$item->user->phone }}</span></p>
                                                </li>
                                                <li>
                                                    <p>@lang('home.email') : <span> {{ @$item->user->email }}</span></p>
                                                </li>
                                                <li>
                                                    <p>@lang('home.address') : <span>  {{ @$item->user->address }}</span></p>
                                                </li>
                                            </ul>
                                        </div>
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320">
                                            <path fill="#0099ff" fill-opacity="1"
                                                d="M0,32L34.3,80C68.6,128,137,224,206,234.7C274.3,245,343,171,411,149.3C480,128,549,160,617,144C685.7,128,754,64,823,80C891.4,96,960,192,1029,202.7C1097.1,213,1166,139,1234,112C1302.9,85,1371,107,1406,117.3L1440,128L1440,320L1405.7,320C1371.4,320,1303,320,1234,320C1165.7,320,1097,320,1029,320C960,320,891,320,823,320C754.3,320,686,320,617,320C548.6,320,480,320,411,320C342.9,320,274,320,206,320C137.1,320,69,320,34,320L0,320Z">
                                            </path>
                                        </svg>
                                    </a>
                                        @if(Auth::check() && Auth::id() != $item->user_id)
                                        {{-- <a href="#">ألغاء المتابعة</a> --}}
                                        @if(in_array(Auth::id(),$list->toArray()) ==false)
                                        <span class="follow-btn">
                                        <a href="{{ url(LaravelLocalization::getCurrentLocale()).'/user/'.'follow/u/'.@$item->user_id }}" class="">follow</a>
                                        @else
                                        <a href="{{ url(LaravelLocalization::getCurrentLocale()).'/user/'.'follow/u/'.@$item->user_id }}" class="">unfollow</a>
                                        </span>
                                        @endif
                                        @endif
                                </div>
                            </div>
                            @endforeach
                            @else 
                            <div>
                                <center>
                                    @lang('home.empty')
                                </center>
                            </div>
                            @endif
                            {{-- <div class="col-lg-4">
                                <div class="items">
                                    <a href="#">
                                        <div class="icon">
                                            <img src="images/trainer.jpg" alt="">
                                        </div>
                                        <div class="content">
                                            <h5>محمد احمد</h5>
                                            <ul>
                                                <li>
                                                    <p>الهاتف : <span> +10231456879</span></p>
                                                </li>
                                                <li>
                                                    <p>الايميل : <span> example@gmail.com</span></p>
                                                </li>
                                                <li>
                                                    <p>العنوان : <span> السعوديه - جده</span></p>
                                                </li>
                                            </ul>
                                        </div>
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320">
                                            <path fill="#00D15B" fill-opacity="1"
                                                d="M0,32L34.3,80C68.6,128,137,224,206,234.7C274.3,245,343,171,411,149.3C480,128,549,160,617,144C685.7,128,754,64,823,80C891.4,96,960,192,1029,202.7C1097.1,213,1166,139,1234,112C1302.9,85,1371,107,1406,117.3L1440,128L1440,320L1405.7,320C1371.4,320,1303,320,1234,320C1165.7,320,1097,320,1029,320C960,320,891,320,823,320C754.3,320,686,320,617,320C548.6,320,480,320,411,320C342.9,320,274,320,206,320C137.1,320,69,320,34,320L0,320Z">
                                            </path>
                                        </svg>
                                    </a>
                                    <span class="follow-btn"><a href="#">ألغاء المتابعة</a></span>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="items">
                                    <a href="#">
                                        <div class="icon">
                                            <img src="images/trainer.jpg" alt="">
                                        </div>
                                        <div class="content">
                                            <h5>محمد احمد</h5>
                                            <ul>
                                                <li>
                                                    <p>الهاتف : <span> +10231456879</span></p>
                                                </li>
                                                <li>
                                                    <p>الايميل : <span> example@gmail.com</span></p>
                                                </li>
                                                <li>
                                                    <p>العنوان : <span> السعوديه - جده</span></p>
                                                </li>
                                            </ul>
                                        </div>
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320">
                                            <path fill="#0099ff" fill-opacity="1"
                                                d="M0,32L34.3,80C68.6,128,137,224,206,234.7C274.3,245,343,171,411,149.3C480,128,549,160,617,144C685.7,128,754,64,823,80C891.4,96,960,192,1029,202.7C1097.1,213,1166,139,1234,112C1302.9,85,1371,107,1406,117.3L1440,128L1440,320L1405.7,320C1371.4,320,1303,320,1234,320C1165.7,320,1097,320,1029,320C960,320,891,320,823,320C754.3,320,686,320,617,320C548.6,320,480,320,411,320C342.9,320,274,320,206,320C137.1,320,69,320,34,320L0,320Z">
                                            </path>
                                        </svg>
                                    </a>
                                    <span class="follow-btn"><a href="#">ألغاء المتابعة</a></span>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="items">
                                    <a href="#">
                                        <div class="icon">
                                            <img src="images/trainer.jpg" alt="">
                                        </div>
                                        <div class="content">
                                            <h5>محمد احمد</h5>
                                            <ul>
                                                <li>
                                                    <p>الهاتف : <span> +10231456879</span></p>
                                                </li>
                                                <li>
                                                    <p>الايميل : <span> example@gmail.com</span></p>
                                                </li>
                                                <li>
                                                    <p>العنوان : <span> السعوديه - جده</span></p>
                                                </li>
                                            </ul>
                                        </div>
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320">
                                            <path fill="#00D15B" fill-opacity="1"
                                                d="M0,32L34.3,80C68.6,128,137,224,206,234.7C274.3,245,343,171,411,149.3C480,128,549,160,617,144C685.7,128,754,64,823,80C891.4,96,960,192,1029,202.7C1097.1,213,1166,139,1234,112C1302.9,85,1371,107,1406,117.3L1440,128L1440,320L1405.7,320C1371.4,320,1303,320,1234,320C1165.7,320,1097,320,1029,320C960,320,891,320,823,320C754.3,320,686,320,617,320C548.6,320,480,320,411,320C342.9,320,274,320,206,320C137.1,320,69,320,34,320L0,320Z">
                                            </path>
                                        </svg>
                                    </a>
                                    <span class="follow-btn"><a href="#">ألغاء المتابعة</a></span>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="items">
                                    <a href="#">
                                        <div class="icon">
                                            <img src="images/trainer.jpg" alt="">
                                        </div>
                                        <div class="content">
                                            <h5>محمد احمد</h5>
                                            <ul>
                                                <li>
                                                    <p>الهاتف : <span> +10231456879</span></p>
                                                </li>
                                                <li>
                                                    <p>الايميل : <span> example@gmail.com</span></p>
                                                </li>
                                                <li>
                                                    <p>العنوان : <span> السعوديه - جده</span></p>
                                                </li>
                                            </ul>
                                        </div>
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320">
                                            <path fill="#0099ff" fill-opacity="1"
                                                d="M0,32L34.3,80C68.6,128,137,224,206,234.7C274.3,245,343,171,411,149.3C480,128,549,160,617,144C685.7,128,754,64,823,80C891.4,96,960,192,1029,202.7C1097.1,213,1166,139,1234,112C1302.9,85,1371,107,1406,117.3L1440,128L1440,320L1405.7,320C1371.4,320,1303,320,1234,320C1165.7,320,1097,320,1029,320C960,320,891,320,823,320C754.3,320,686,320,617,320C548.6,320,480,320,411,320C342.9,320,274,320,206,320C137.1,320,69,320,34,320L0,320Z">
                                            </path>
                                        </svg>
                                    </a>
                                    <span class="follow-btn"><a href="#">ألغاء المتابعة</a></span>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="items">
                                    <a href="#">
                                        <div class="icon">
                                            <img src="images/trainer.jpg" alt="">
                                        </div>
                                        <div class="content">
                                            <h5>محمد احمد</h5>
                                            <ul>
                                                <li>
                                                    <p>الهاتف : <span> +10231456879</span></p>
                                                </li>
                                                <li>
                                                    <p>الايميل : <span> example@gmail.com</span></p>
                                                </li>
                                                <li>
                                                    <p>العنوان : <span> السعوديه - جده</span></p>
                                                </li>
                                            </ul>
                                        </div>
                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320">
                                            <path fill="#00D15B" fill-opacity="1"
                                                d="M0,32L34.3,80C68.6,128,137,224,206,234.7C274.3,245,343,171,411,149.3C480,128,549,160,617,144C685.7,128,754,64,823,80C891.4,96,960,192,1029,202.7C1097.1,213,1166,139,1234,112C1302.9,85,1371,107,1406,117.3L1440,128L1440,320L1405.7,320C1371.4,320,1303,320,1234,320C1165.7,320,1097,320,1029,320C960,320,891,320,823,320C754.3,320,686,320,617,320C548.6,320,480,320,411,320C342.9,320,274,320,206,320C137.1,320,69,320,34,320L0,320Z">
                                            </path>
                                        </svg>
                                    </a>
                                    <span class="follow-btn"><a href="#">ألغاء المتابعة</a></span>
                                </div>
                            </div> --}}

                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>
    <!--End-Contents-->
@stop