@extends('front.layouts.main')
@section('meta_tags')
    <title>@lang('home.groups') | {{@$setting->translation->title}}</title>
    <meta name='description' itemprop='description' content='{!! @$info->translation->content!!}' />
    <meta name='keywords' content='{!!@$setting->meta_tags!!},{!!@$info->translation->title !!},{!!@$info->mission !!},{!!@$info->goals!!}' />
    <meta property="og:description"content="{{ @$info->translation->content }}" />
    <meta property="og:title"content="@lang('home.groups') | {{@$setting->translation->title}} " />
    <meta property="og:url"content="{{URL::to('/about_us')}}" />
    <meta property="og:site_name"content="{{@$setting->translation->title}}" />
    <meta property="og:image" content="{{URL::to('/').@$setting->logo}}">

    <meta name="twitter:card"content="summary" />
    <meta name="twitter:title"content="@lang('home.groups')| {{@$setting->translation->title}}" />
    <meta name="twitter:site"content="@wait" />
@stop
@section('content')
<!--Contents-->
    <main class="inner-pages">
        <div class="inner-header">
            <div class="page-title">
                <div class="container">
                    <h5 class=""><a href="{{ url(LaravelLocalization::getCurrentLocale()) }}">@lang('home.home')</a> / @lang('home.groups')</h5>
                </div>
            </div>
        </div>
        <!-- ======================== start about =========================== -->
        <section class="groups section-padding">
            <div class="container">
                <div class="section-head text-center">
                    <h2>@lang('home.group_control')</h2>
                </div>
                <ul class="nav nav-tabs justify-content-center" id="myTab" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" id="personal-tab" data-toggle="tab" href="#personal" role="tab"
                            aria-controls="personal" aria-selected="true">@lang('home.group_i_manage') </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" id="agency-tab" data-toggle="tab" href="#agency" role="tab"
                            aria-controls="agency" aria-selected="false">مجموعات اتابعها</a>
                    </li>
                </ul>
                <div class="tab-content" id="myTabContent">
                    <div class="tab-pane fade show active" id="personal" role="tabpanel" aria-labelledby="personal-tab">
                        <div class="row">
                            @foreach($groups as $group)
                            <div class="col-lg-4">
                                <div class="items">
                                    <h5><a href="#">{{ @$group->transaltions->where('lang_id',$active_lang->id)->first()->name }}</a></h5>
                                    <small>@lang('home.adminstrator') : <span> {{ @$group->adminstrator->fname }}</span></small>
                                </div>
                            </div>
                            @endforeach
{{--                             <div class="col-lg-4">
                                <div class="items">
                                    <h5><a href="#">أسم المجموعه</a></h5>
                                    <small>الادمن : <span> اسامه محمد</span></small>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="items">
                                    <h5><a href="#">أسم المجموعه</a></h5>
                                    <small>الادمن : <span> اسامه محمد</span></small>
                                </div>
                            </div> --}}
                          {{--   <div class="col-lg-4">
                                <div class="items">
                                    <h5><a href="#">أسم المجموعه</a></h5>
                                    <small>الادمن : <span> اسامه محمد</span></small>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="items">
                                    <h5><a href="#">أسم المجموعه</a></h5>
                                    <small>الادمن : <span> اسامه محمد</span></small>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="items">
                                    <h5><a href="#">أسم المجموعه</a></h5>
                                    <small>الادمن : <span> اسامه محمد</span></small>
                                </div>
                            </div> --}}
                        </div>
                    </div>
                    <div class="tab-pane fade" id="agency" role="tabpanel" aria-labelledby="agency-tab">
                        <div class="row">
                            <div class="col-lg-4">
                                <div class="items">
                                    <h5><a href="#">أسم المجموعه</a></h5>
                                    <small>عدد المتابعين : <span> 121</span></small>
                                    <span class="out-group"><a href="#">الغاء المتابعه</a></span>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="items">
                                    <h5><a href="#">أسم المجموعه</a></h5>
                                    <small>عدد المتابعين : <span> 121</span></small>
                                    <span class="out-group"><a href="#">الغاء المتابعه</a></span>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="items">
                                    <h5><a href="#">أسم المجموعه</a></h5>
                                    <small>عدد المتابعين : <span> 121</span></small>
                                    <span class="out-group"><a href="#">الغاء المتابعه</a></span>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="items">
                                    <h5><a href="#">أسم المجموعه</a></h5>
                                    <small>عدد المتابعين : <span> 121</span></small>
                                    <span class="out-group"><a href="#">الغاء المتابعه</a></span>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="items">
                                    <h5><a href="#">أسم المجموعه</a></h5>
                                    <small>عدد المتابعين : <span> 121</span></small>
                                    <span class="out-group"><a href="#">الغاء المتابعه</a></span>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="items">
                                    <h5><a href="#">أسم المجموعه</a></h5>
                                    <small>عدد المتابعين : <span> 121</span></small>
                                    <span class="out-group"><a href="#">الغاء المتابعه</a></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>
    <!--End-Contents-->

@stop