@extends('panel.layouts.layout')
@section('content')
	  <!-- =====================================
        ==== Start Home-content  -->

        <section class="users-list">
            <div class="container-fluid">

                <div class="row">
                    <div class="col-md-11">
                        <div class="wel-text">
                            <div class="path">
                                <a href="{{ url('admin/home') }}">@lang('home.home')</a><span>/</span>@lang('home.full_report') 
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-1">
                        <div class="dropdown">
                          <button class="btn btn-defualt dropdown-toggle" type="button" data-toggle="dropdown">@lang('home.links')
                              <span class="caret"></span></button>
                              <ul class="dropdown-menu" style="padding: 10px">
                                <li  style="padding: 10px"><a href="{{ URL::to('ar/admin/setting') }}"><i class="icon-gear"></i>@lang('home.general_settings')</a></li>
                                <li  style="padding: 5px"><a href="{{ URL::to('ar/admin/reports_browsing') }}"><i class="icon-copy"></i> @lang('home.full_report')</a></li>
                            </ul>
                        </div>
                    </div>
                </div>

                <table class="block-table">
                    <tbody>
                        <tr>
                            <th>@lang('home.user')</th>                                        
                            <th>@lang('home.action')</th>
                            <th>@lang('home.since')</th>
                            <th>@lang('home.ip')</th>
                            <th>@lang('home.location')</th>
                            <th>@lang('home.browser')</th>
                            <th>@lang('home.user_full_reports')</th>

                        </tr>
                        @foreach($reports as $user)            
                        <tr>
                            <td>
                                <div class="img"><img src="{{ asset('/') }}{{ @$user->image }}" alt=""></div> <span>{{ @$user->fname.' '.$user->lname }}</span>
                            </td>
                            <td>{{ @$user->last_report()->text }}</td>
                            <td>{{@Carbon\Carbon::parse($user->last_report()->created_at)->diffForHumans()}}</td>
                            <td>{{ @$user->last_report()->ip }}</td>
                            <td>{{ @$user->last_report()->location }}</td>
                           <td>{{ @$user->last_report()->browser }}</td>
                            <td>
                                <a href="{{URL::to('ar/admin/reports_browsing/').'/'.$user->id.'/u/'.@$user->fname}}" class="btn btn-primary"> <li class="icon ti-marker-alt"></li></a>
                            </td>   
                           
                        </tr>
                        @endforeach

                    </tbody>
                </table>
            </div>
        </section>
@stop