@extends('panel.layouts.layout')
@section('content')

     <!-- =====================================
        ==== Start settings  -->
        <br>
        <section class="settings">
            <div class="container-fluid">
             <div class="row">
                <div class="col-md-11">
                    <div class="wel-text">
                        <div class="path">
                            <a href="{{ url('admin/home') }}">@lang('home.home')</a>
                            <span>/</span>
                            <a href="{{ url('admin/users') }}">@lang('home.users')</a>
                            <span>/</span>@lang('home.create_users') 
                        </div>
                    </div>
                </div>

                <div class="col-md-1">
                    <div class="dropdown">
                      <button class="btn btn-defualt dropdown-toggle" type="button" data-toggle="dropdown">@lang('home.links')
                          <span class="caret"></span></button>
                          <ul class="dropdown-menu" style="padding: 10px">
                            <li  style="padding: 10px"><a href="{{ URL::to('ar/admin/setting') }}"><i class="icon-gear"></i>@lang('home.general_settings')</a></li>
                            <li  style="padding: 5px"><a href="{{ URL::to('ar/admin/reports_browsing') }}"><i class="icon-copy"></i> @lang('home.full_report')</a></li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-lg-12 col-md-6">
                    <div class="item">
                        <div class="head">
                            <h5> @lang('home.create_users')</h5>
                        </div>
                        <form class="form-horizontal form-validate-jquery" method="POST" action="{{ URL::to('/admin/users') }}" enctype='multipart/form-data'>
                            @if ($errors->any())
                            @foreach ($errors->all() as $error)
                            <div class="alert alert-danger alert-dismissible" >
                                <a href="#" class="close" data-dismiss="alert" aria-label="close" style="right: 5px;">&times;</a>{{ $error }}
                            </div>
                            @endforeach
                            @endif
                            @if(Session::has('success'))
                            <div class="alert alert-success alert-dismissible">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close" style="right: 5px;">&times;</a>{{ Session::get('success') }}
                            </div>
                            @endif
                            @csrf

                            <!-- title ar input -->
                            <div class="form-group">
                                <label class="control-label col-lg-3">@lang('home.fname') <span class="text-danger" title="@lang('home.required')">*</span></label>
                                <div class="col-lg-12">
                                    <input type="text" name="fname" class="form-control" placeholder="@lang('home.fname')" value="{{Request::old('fname')}}">
                                </div>
                            </div>
                            <!-- /title ar input -->

                            <!-- title ar input -->
                            <div class="form-group">
                                <label class="control-label col-lg-3">@lang('home.lname') <span class="text-danger" title="@lang('home.required')">*</span></label>
                                <div class="col-lg-12">
                                    <input type="text" name="lname" class="form-control"  placeholder="@lang('home.lname')" value="{{Request::old('lname')}}">
                                </div>
                            </div>
                            <!-- /title ar input -->

                            <!-- Family Name input -->
                            <div class="form-group">
                                <label class="control-label col-lg-3">@lang('home.family_name') <span class="text-danger" title="@lang('home.required')">*</span></label>
                                <div class="col-lg-12">
                                    <input type="text" name="family_name" class="form-control"  placeholder="@lang('home.family_name')" value="{{Request::old('family_name')}}">
                                </div>
                            </div>
                            <!-- /Family Name input -->


                            <!-- content ar input -->
                            <div class="form-group">
                                <label class="control-label col-lg-3">@lang('home.email') <span class="text-danger" title="@lang('home.required')">*</span></label>
                                <div class="col-lg-12">
                                    <input type="email" name="email" class="form-control"  placeholder="@lang('home.email')" value="{{Request::old('email')}}">
                                </div>
                            </div>
                            <!-- /content ar input -->
                            <!-- Meta Tags input -->
                            <div class="form-group">
                                <label class="control-label col-lg-3">@lang('home.phone') <span class="text-danger" title="@lang('home.required')">*</span></label>
                                <div class="col-lg-12">
                                    <input type="text" name="phone" class="form-control" placeholder="@lang('home.phone')" value="{{Request::old('phone')}}">
                                </div>
                            </div>
                            <!-- /Meta Tags input -->
                            <!-- content en input -->
                            <div class="form-group">
                                <label class="control-label col-lg-3">@lang('home.country') <span class="text-danger" title="@lang('home.required')">*</span></label>
                                <div class="col-lg-12"> 
                                    <select name="country_id" class="form-control" >
                                        <option value="null">@lang('home.select_one')</option>
                                        @foreach($countries as $country)
                                        <option value="{{ @$country->id }}" @if($country->id == Auth::user()->country_id) selected @endif>{{ @$country->translations->first()->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <!-- /content en input -->
                            <!-- content en input -->
                            <div class="form-group">
                                <label class="control-label col-lg-3">@lang('home.city') <span class="text-danger" title="@lang('home.required')">*</span></label>
                                <div class="col-lg-12"> 
                                    <select name="city_id" class="form-control" >
                                        <option value="null">@lang('home.select_one')</option>
                                        @foreach($cities as $city)
                                        <option value="{{ @$city->id }}" @if($city->id == Auth::user()->city_id) selected @endif>{{ @$city->translation->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <!-- /content en input -->
                            <!-- password input -->
                            <div class="form-group">

                                <div class="col-lg-3">
                                    <label class="control-label">@lang('home.password')<span class="text-danger" title="@lang('home.required')">*</span> </label> <br>
                                    <small> - الأحرف الكبيرة الإنجليزية (A - Z) <br>- الأحرف الصغيرة الإنجليزية (a - z) <br>- الأساس 10 أرقام (0 - 9)</small>
                                </div>
                                <div class="col-lg-12">
                                    <div class="input-group">
                                        @if(LaravelLocalization::getCurrentLocale() == 'en')
                                        <input type="text" class="form-control" name="password" placeholder="@lang('home.password')" id="input_password">

                                        <span class="input-group-btn">
                                            <button class="btn btn-default legitRipple" type="button" id="generate_password">
                                                @lang('home.generate') 
                                                <li class="glyphicon glyphicon-eye-open"></li>
                                            </button>
                                        </span>

                                        @else


                                        <span class="input-group-btn">
                                            <button class="btn btn-default legitRipple" type="button" id="generate_password">
                                                @lang('home.generate') 
                                                <li class="glyphicon glyphicon-eye-open"></li>
                                            </button>
                                        </span>
                                        <input type="text" class="form-control" name="password"  placeholder="@lang('home.password')" id="input_password">

                                        @endif
                                    </div>

                                </div>
                            </div>

                            <div class="form-group">
                                <label class="control-label col-lg-3">@lang('home.password_confirmation') <span class="text-danger" title="@lang('home.required')">*</span></label>
                                <div class="col-lg-12">
                                    <input type="password" name="password_confirmation" class="form-control"  id="input_password_confirm">
                                </div>
                            </div>

                            <!--/password input -->

                            <!-- Family Name input -->
                            <div class="form-group">
                                <label class="control-label col-lg-3">@lang('home.birthdate') <span class="text-danger" title="@lang('home.required')">*</span></label>
                                <div class="col-lg-12">
                                    <input type="date" name="birthdate" class="form-control"  placeholder="@lang('home.birthdate')" value="{{Request::old('birthdate')}}">

                                  
                                </div>
                            </div>
                            <!-- /Family Name input -->
                            <!-- Family Name input -->
                            <div class="form-group">
                                <label class="control-label col-lg-3">@lang('home.gander') <span class="text-danger" title="@lang('home.required')">*</span></label>
                                <div class="col-lg-12">
                                 <select name="gander" class="form-control">
                                     <option value="male">@lang('home.male')</option>
                                     <option value="female">@lang('home.female')</option>
                                 </select>
                             </div>
                         </div>
                         <!-- /Family Name input -->
                         <!-- Logo uploader -->
                         <div class="form-group">
                            <label class="control-label col-lg-3">@lang('home.avatar') <span class="text-danger" title="@lang('home.required')"> *</span></label>
                            <div class="col-lg-9">
                                <input type="file" name="image" class="file-styled" >
                            </div>
                        </div>
                        <!-- /Logo uploader -->
                        <button type="submit" class="btn btn-primary">@lang('home.save') <i class="icon-arrow-left13 position-right"></i></button>

                    </form>
                </div>
            </div>



        </div>
    </div>
</section>

        <!-- End settings  ====
            ======================================= -->


            @stop

            @section('jsCode')
            <script>
                $('#generate_password').click(function(){
                    var randomstring = Math.random().toString(36).slice(-8);
                    $('#input_password').val(randomstring);input_password_confirm
                    $('#input_password_confirm').val(randomstring);


                });
            </script>
            @stop
