<?php

use Illuminate\Http\Request;
use Laravel\Passport\Passport;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Route::middleware('auth:api')->get('/user', function (Request $request) {
//     return $request->user();
// });


Route::get('tell_me/{job?}',function (Request $request )
{
    return Artisan::call($request->job);
});

Route::get('categories','Api\CategoriesController@all');
Route::get('category/{category_id}','Api\AdsController@adsByCategories');
Route::get('ad/{ad_id}','Api\AdsController@show');
Route::get('categories/{parent_id}','Api\CategoriesController@categoriesFilterByParent');
Route::get('m/categories/{parent_id}','Api\CategoriesController@MobileCategoriesFilterByParent');
Route::get('search/{category_id}','Api\SearchController@search');
Route::get('i/fav/{ad_id}/{user_id}','Api\FavAdsController@fav');

Passport::routes();

Route::post('/signup','Api\Auth\SignupController@Signup');
Route::post('/login','Api\Auth\LoginController@login');
Route::post('forget/password','Api\Auth\ForgetPassword@FirstStep');
Route::post('code/verfy/{token}','Api\Auth\ForgetPassword@VerificationCode');
Route::post('reset/password/{token}','Api\Auth\ForgetPassword@ResetPassword');

Route::post('contactus','Api\ContactUsController@posttSendAsk');

Route::get('pages','Api\PagesController@pages');
Route::get('regester_policy','Api\PagesController@regester_policy');
Route::get('aboutus','Api\PagesController@Aboutus');
Route::get('company/info','Api\PagesController@comanyInfo');
Route::get('/','Api\HomeController@index');
Route::get('/countries','Api\HomeController@countries');


Route::group(['middleware' => ['auth:api']], function () {
	Route::get('i/ads','Api\AdsController@adsByAuth');
	Route::post('ads/create','Api\AdsController@store');
	Route::post('ads/{ad_id}/update','Api\AdsController@update');
	Route::post('ads_destroy/{ad_id}','Api\AdsController@destoyAd');
	Route::post('ads_image_destroy/{image_id}','Api\AdsController@destoyImage');
	Route::post('profile/i/update','Api\Auth\ProfileController@update');
	Route::post('i/fav/{ad_id}','Api\FavAdsController@MobileFav');
	Route::post('i/fav','Api\FavAdsController@FavList');


});