<!DOCTYPE html>
<html lang="zxx">

<head>

    <!-- Metas -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
    <meta name="keywords" content="" />
    <meta name="description" content="" />
    <meta name="author" content="" />

    <!-- Title  -->
    <title><?php echo e(@$setting->translation->title); ?></title>
    <?php echo $__env->make('panel.layouts.meta_tags_social', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Favicon -->
    <link rel="shortcut icon" href="<?php echo e(asset('/cpanel')); ?>/images/favicon.png" />

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Cairo:200,300,400,600,700,900&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Tajawal:200,300,400,500,700,800,900&display=swap"
        rel="stylesheet">

    <!-- Plugins -->
    <link rel="stylesheet" href="<?php echo e(asset('/cpanel')); ?>/css/plugins.css" />

    <!-- bootstrap-ltr.min -->
    

    <!-- bootstrap-rtl.min -->
    <link rel="stylesheet" href="<?php echo e(asset('/cpanel')); ?>/css/bootstrap-rtl.min.css" />

    <!-- Core Style Css -->
    <link rel="stylesheet" href="<?php echo e(asset('/cpanel')); ?>/css/style.css" />
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css">
    <script src="//cdn.ckeditor.com/4.13.0/full/ckeditor.js"></script>
    

</head>

<body>

    <!-- =====================================
          ==== Start Loading -->

    <div class="loading valign">
        <div class="full-width">
            <div class="lds-ripple">
                <div></div>
                <div></div>
            </div>
            <div class="load-logo">
                <img src="<?php echo e(asset('/').@$setting->logo); ?>" alt="">
            </div>
        </div>
    </div>

    <!-- End Loading ====
        ======================================= -->



    <!-- =====================================
        ==== Start Navbar -->

    <div class="side-bar stylebar">
        <div class="bg-img" data-background="<?php echo e(asset('/cpanel/images/sidebar-bg.jpg')); ?>"></div>
        <div class="user-profile padding">
            <div class="profile-img">
                <img src="<?php echo e(asset('/').Auth::user()->image); ?>" alt="">
            </div>
            <div class="cont">
                <h6>مرحبا بك <strong><?php echo e(@Auth::user()->fname.' '.@Auth::user()->lname); ?></strong></h6>
            </div>
        </div>
        <div class="nav-list">
            <ul>
                <li><a href="<?php echo e(URL::to('admin/home')); ?>"><i class="icon ti-home"></i><span class="text"><?php echo app('translator')->getFromJson('home.home'); ?></span></a></li>
                <li><a href="<?php echo e(URL::to('admin/setting')); ?>"><i class="icon fas fa-cogs"></i><span class="text"> <span><?php echo app('translator')->getFromJson('home.general_settings'); ?></span></a></li>
                
                <li class="accordion">
                    <div class='card-head'>
                        <a href="#0"><i class="icon ti-user"></i><span class="text"><?php echo app('translator')->getFromJson('home.users'); ?></span></a>
                    </div>
                    <div class='card-body'>
                        <ul>
                            <li><a href="<?php echo e(URL::to('admin/users')); ?>"><i class="icon ti-user"></i><span class="text"><?php echo app('translator')->getFromJson('home.users'); ?></span></a></li>
                            <li><a href="<?php echo e(URL::to('admin/users/create')); ?>"><i class="icon ti-location-arrow"></i><span class="text"><?php echo app('translator')->getFromJson('home.create_users'); ?></span></a></li>
                        </ul>
                    </div>
                    <span class="drop-icon"><i class="fas fa-caret-down"></i></span>
                </li>
                
                <li class="accordion">
                    <div class='card-head'>
                        <a href="#0"><i class="icon ti-package"></i><span class="text"><?php echo app('translator')->getFromJson('home.sliders'); ?></span></a>
                    </div>
                    <div class='card-body'>
                        <ul>
                            <li><a href="<?php echo e(URL::to('/admin/sliders')); ?>"><i class="icon ti-package"></i><span class="text"><?php echo app('translator')->getFromJson('home.sliders'); ?></span></a></li>
                            <li><a href="<?php echo e(URL::to('/admin/sliders/create')); ?>"><i class="icon ti-location-arrow"></i><span class="text"><?php echo app('translator')->getFromJson('home.new_slider'); ?></span></a></li>
                        </ul>
                    </div>
                    <span class="drop-icon"><i class="fas fa-caret-down"></i></span>
                </li>
                
                <li class="accordion">
                    <div class='card-head'>
                        <a href="#0"><i class="icon ti-package"></i><span class="text"><?php echo app('translator')->getFromJson('home.countries'); ?> & <?php echo app('translator')->getFromJson('home.places'); ?> & <?php echo app('translator')->getFromJson('home.cities'); ?> </span></a>
                    </div>
                    <div class='card-body'>
                        <ul>
                            <li><a href="<?php echo e(URL::to('/admin/countries')); ?>"><i class="icon ti-package"></i><span class="text"><?php echo app('translator')->getFromJson('home.countries'); ?> & <?php echo app('translator')->getFromJson('home.places'); ?> & <?php echo app('translator')->getFromJson('home.cities'); ?> </span></a></li>
                            <li><a href="<?php echo e(URL::to('/admin/countries/create')); ?>"><i class="icon ti-location-arrow"></i><span class="text"><?php echo app('translator')->getFromJson('home.new_country'); ?></span></a></li>
                        </ul>
                    </div>
                    <span class="drop-icon"><i class="fas fa-caret-down"></i></span>
                </li>
                
                <li class="accordion">
                    <div class='card-head'>
                        <a href="#0" class=""><i class="icon ti-layout"></i><span class="text"><?php echo app('translator')->getFromJson('home.categories_list'); ?></span></a>
                    </div>
                    <div class='card-body'>
                        <ul>
                            <li><a href="<?php echo e(URL::to('ar/admin/categories')); ?>" class=""><i class="icon ti-layout"></i><span class="text"><?php echo app('translator')->getFromJson('home.categories_list'); ?></span></a></li>
                            <li><a href="<?php echo e(URL::to('ar/admin/categories/create')); ?>" class=""><i class="icon ti-location-arrow"></i><span class="text"><?php echo app('translator')->getFromJson('home.create_categories'); ?></span></a></li>
                        </ul>
                    </div>
                    <span class="drop-icon"><i class="fas fa-caret-down"></i></span>
                </li>
             

                <li class="accordion">
                    <div class='card-head'>
                        <a href="#0" class="">  
                            <i class="icon ti-stats-up"></i>  <?php echo app('translator')->getFromJson('home.ads_list'); ?>
                        </a>
                    </div>
                    <div class='card-body'>
                        <ul>
                           <li>
                                <a href="<?php echo e(URL::to('/admin/ads')); ?>" class="">  
                                <i class="icon ti-stats-up"></i> <?php echo app('translator')->getFromJson('home.ads_list'); ?>
                                </a>
                            </li>
                           
                            <li>
                                <a href="<?php echo e(URL::to('/admin/banned_ads')); ?>" class="">  
                                <i class="icon ti-stats-up"></i> <?php echo app('translator')->getFromJson('home.ads_list_blocked'); ?>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(URL::to('/admin/ads/create')); ?>" class="">  
                                <i class="icon ti-location-arrow"></i> <?php echo app('translator')->getFromJson('home.create_ad'); ?>
                                </a>
                            </li>
                           
                        </ul>
                    </div>
                    <span class="drop-icon"><i class="fas fa-caret-down"></i></span>
                </li>
              
          
                 
                <li class="accordion">
                    <div class='card-head'>
                        <a href="#0"><i class="icon ti-harddrives"></i><span class="text"><?php echo app('translator')->getFromJson('home.pages_list'); ?></span></a>
                    </div>
                    <div class='card-body'>
                        <ul>
                           <li><a href="<?php echo e(URL::to('/admin/pages')); ?>"><i class="icon ti-harddrives"></i><span class="text"><?php echo app('translator')->getFromJson('home.pages_list'); ?></span></a></li>
                            <li><a href="<?php echo e(URL::to('/admin/aboutus')); ?>" class=""><i class="icon ti-harddrives"></i><span class="text"><?php echo app('translator')->getFromJson('home.about_us'); ?></span></a></li>
                            <li><a href="<?php echo e(URL::to('/admin/pages/create')); ?>"><i class="icon ti-location-arrow"></i><span class="text"><?php echo app('translator')->getFromJson('home.create_page'); ?></span></a></li>
                        </ul>
                    </div>
                    <span class="drop-icon"><i class="fas fa-caret-down"></i></span>
                </li>
                
                <li class="accordion">
                    <div class='card-head'>
                        <a href="#0" class="">  
                            <i class="icon  ti-announcement"></i> <?php echo app('translator')->getFromJson('home.notifications'); ?>
                        </a>
                    </div>
                    <div class='card-body'>
                        <ul>
                           <li>
                                <a href="<?php echo e(URL::to('/admin/notifications')); ?>" class="">  
                                <i class="icon  ti-announcement"></i> <?php echo app('translator')->getFromJson('home.notifications'); ?>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(URL::to('/admin/notifications/create')); ?>" class="">  
                                <i class="icon  ti-announcement"></i> <?php echo app('translator')->getFromJson('home.new_notification'); ?>
                                </a>
                            </li>
                        </ul>
                    </div>
                    <span class="drop-icon"><i class="fas fa-caret-down"></i></span>
                </li>
                
                <li><a href="<?php echo e(URL::to('/admin/contactus')); ?>" class="">  
                    
                    <i class="icon far fa-bell"></i>
                    <?php if($contact->count() > 0 ): ?><small class="badge badge-primary"><?php echo e(@$contact->count()); ?></small><?php endif; ?> <?php echo app('translator')->getFromJson('home.contactus_list'); ?></a></li>

                <li><a href="<?php echo e(URL::to('/logout')); ?>"><i class="icon fas fa-power-off"></i> <span><?php echo app('translator')->getFromJson('home.logout'); ?></span></a></li>
                
                
            </ul>
        </div>
    </div>

    <!-- End Navbar ====
        ======================================= -->

    <main class="bg-gray">

        <!-- =====================================
        ==== Start nav-top -->

        <div class="nav-top">
            <div class="container-fluid">
                <div class="toggle-icon flex">
                    <span class="icon"><i class="fas fa-bars"></i></span>
                </div>
                <div class="search-form flex">
                    <form action="">
                        <input type="text" name="search" placeholder="ابحث عن">
                        <button><i class="fas fa-search"></i></button>
                    </form>
                </div>
                <div class="quick-links">
                    <ul>
                        <li class="dropdown messages">
                            <div class="item" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                aria-expanded="false">
                                <div><i class="ti-comment-alt"></i><span class="num">4</span></div>
                            </div>
                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                <div class="head">
                                    <span class="title">الرسائل</span>
                                    <span class="clear"><a href="#0">تعليم كمقروء</a></span>
                                </div>
                                <ul>
                                    <li>
                                        <div class="img">
                                            <img src="images/user/1.jpg" alt="">
                                        </div>
                                        <div class="cont">
                                            <h6>ساره احمد</h6>
                                            <p>رجاء تفحص بريدك الإلكتروني !!</p>
                                            <span>من دقيقة واحده</span>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="img">
                                            <img src="images/user/2.jpg" alt="">
                                        </div>
                                        <div class="cont">
                                            <h6>ساره احمد</h6>
                                            <p>رجاء تفحص بريدك الإلكتروني !!</p>
                                            <span>من 10 دقيقة</span>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="img">
                                            <img src="images/user/3.jpg" alt="">
                                        </div>
                                        <div class="cont">
                                            <h6>ساره احمد</h6>
                                            <p>رجاء تفحص بريدك الإلكتروني !!</p>
                                            <span>من 20 دقيقة</span>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="img">
                                            <img src="images/user/4.jpg" alt="">
                                        </div>
                                        <div class="cont">
                                            <h6>ساره احمد</h6>
                                            <p>رجاء تفحص بريدك الإلكتروني !!</p>
                                            <span>من نصف ساعه</span>
                                        </div>
                                    </li>
                                </ul>
                                <div class="bottom">
                                    <a href="#0">عرض الكل</a>
                                </div>
                            </div>
                        </li>
                        <li class="dropdown noti">
                            <div class="item" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                aria-expanded="false">
                                <div><i class="ti-bell"></i><span class="num">6</span></div>
                            </div>
                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                <div class="head">
                                    <span class="title">إشعارات</span>
                                    <span class="clear"><a href="#0">تعليم كمقروء</a></span>
                                </div>
                                <ul>
                                    <li>
                                        <div class="text hot-bg-color">
                                            <span class=""><i class="fab fa-android"></i></span>
                                        </div>
                                        <div class="cont">
                                            <p>تحديث القالب متوفر الآن!</p>
                                            <span>من دقيقة واحده</span>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="text main-bg-color">
                                            <span class=""><i class="fas fa-bell"></i></span>
                                        </div>
                                        <div class="cont">
                                            <p>تحديث القالب متوفر الآن!</p>
                                            <span>من 10 دقيقة</span>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="text sub-bg-color">
                                            <span class=""><i class="fab fa-github"></i></span>
                                        </div>
                                        <div class="cont">
                                            <p>تحديث القالب متوفر الآن!</p>
                                            <span>من 20 دقيقة</span>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="text third-bg-color">
                                            <span class=""><i class="fas fa-check"></i></span>
                                        </div>
                                        <div class="cont">
                                            <p>تحديث القالب متوفر الآن!</p>
                                            <span>من نصف ساعه</span>
                                        </div>
                                    </li>
                                </ul>
                                <div class="bottom">
                                    <a href="#0">عرض الكل</a>
                                </div>
                            </div>
                        </li>
                        <li class="dropdown user-area">
                            <div class="profile-img" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                aria-expanded="false">
                                <img src="<?php echo e(asset('/').Auth::user()->image); ?>" alt="<?php echo e(@Auth::user()->fname.' '.@Auth::user()->lname); ?>">
                            </div>
                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                <a class="dropdown-item" href="#"> <i class="far fa-user"></i> الملف الشخصى</a>
                                <a class="dropdown-item" href="<?php echo e(URL::to('ar/admin/setting')); ?>"> <i class="fas fa-cog"></i><?php echo app('translator')->getFromJson('home.general_settings'); ?></a>
                                <a class="dropdown-item logout" href="<?php echo e(URL::to('/logout')); ?>"> <?php echo app('translator')->getFromJson('home.logout'); ?> <span class="icon"><i
                                            class="fas fa-sign-in-alt"></i></span></a>
                            </div>
                        </li>
                    </ul>
                </div>
                <div class="clear-fix"></div>
            </div>
        </div>

        <!-- End nav-top ====
        ======================================= -->

    <?php echo $__env->yieldContent('content'); ?>






    </main>

    <!-- =====================================
        ==== Start Footer -->



    <!-- End Footer ====
        ======================================= -->





    <!-- jQuery -->
    <script src="<?php echo e(asset('/cpanel')); ?>/js/jquery-3.0.0.min.js"></script>
    <script src="<?php echo e(asset('/cpanel')); ?>/js/jquery-migrate-3.0.0.min.js"></script>

    <!-- popper.min -->
    <script src="<?php echo e(asset('/cpanel')); ?>/js/popper.min.js"></script>

    <!-- bootstrap -->
    <script src="<?php echo e(asset('/cpanel')); ?>/js/bootstrap.min.js"></script>

    <!-- aos js -->
    <script src="<?php echo e(asset('/cpanel')); ?>/js/wow.min.js"></script>

    <!-- jquery-ui  -->
    <script src="<?php echo e(asset('/cpanel')); ?>/js/jquery-ui.js"></script>

    <!-- jquery.magnific-popup.min js -->
    <script src="<?php echo e(asset('/cpanel')); ?>/js/jquery.magnific-popup.min.js"></script>

    <!-- jquery.waypoints.min -->
    <script src="<?php echo e(asset('/cpanel')); ?>/js/jquery.waypoints.min.js"></script>

    <!-- jquery.counterup.min -->
    <script src="<?php echo e(asset('/cpanel')); ?>/js/jquery.counterup.js"></script>

    <!-- validator js -->
    <script src="<?php echo e(asset('/cpanel')); ?>/js/validator.js"></script>

    <!-- custom scripts -->
    <script src="<?php echo e(asset('/cpanel')); ?>/js/scripts.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/1.10.20/js/jquery.dataTables.min.js"></script>
   
    <script>
        new WOW().init();
    </script>

    <script>

        $('.count').counterUp({
            delay: 10,
            time: 2000
        });

        $('.count-long').counterUp({
            delay: 10,
            time: 4000
        });

    </script>

    <script>
        $(function () {

            // Remove svg.radial-progress .complete inline styling
            $('svg.radial-progress').each(function (index, value) {
                $(this).find($('circle.complete')).removeAttr('style');
            });

            // Activate progress animation on scroll
            $(window).scroll(function () {
                $('svg.radial-progress').each(function (index, value) {
                    // If svg.radial-progress is approximately 25% vertically into the window when scrolling from the top or the bottom
                    if (
                        $(window).scrollTop() > $(this).offset().top - ($(window).height() * 0.75) &&
                        $(window).scrollTop() < $(this).offset().top + $(this).height() - ($(window).height() * 0.25)
                    ) {
                        // Get percentage of progress
                        percent = $(value).data('percentage');
                        // Get radius of the svg's circle.complete
                        radius = $(this).find($('circle.complete')).attr('r');
                        // Get circumference (2πr)
                        circumference = 2 * Math.PI * radius;
                        // Get stroke-dashoffset value based on the percentage of the circumference
                        strokeDashOffset = circumference - ((percent * circumference) / 100);
                        // Transition progress for 1.25 seconds
                        $(this).find($('circle.complete')).animate({ 'stroke-dashoffset': strokeDashOffset }, 1250);
                    }
                });
            }).trigger('scroll');

        });
    </script>
    <script>

        var _gaq = _gaq || [];
        _gaq.push(['_setAccount', 'UA-36251023-1']);
        _gaq.push(['_setDomainName', 'jqueryscript.net']);
        _gaq.push(['_trackPageview']);

        (function () {
            var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
            ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
            var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
        })();

    </script>

    <?php echo $__env->yieldContent('jsCode'); ?>


</body>

</html>
<?php /**PATH C:\xampp\htdocs\shorkaa\resources\views/panel/layouts/layout.blade.php ENDPATH**/ ?>